////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ABRACADABRATOOLS - Supprimer les mtadonnes XMP Media Management - XMP Media Management cleaner
// Version 20251115
// Free use and distribution permitted under Creative Commons Attribution 3.0

////////////////////////---ENGLISH---////////////////////////

// abracadabraTools-Remove-xmpMM remove XMPmm tags
// abracadabraTools-Remove-xmpMM is available into the Edit or the Hamburger menu, and as an icon in the Add-On Tools
// abracadabraTools-Remove-xmpMM requires Acrobat Pro or Acrobat Standard


// The xmpMM tags often contain private information about the history of a file which should not be made public.
// This script removes the xmpMM tags from the document's metadata, and (if present) the private tag created by Adobe InDesign.
// We don't need to check if the tags exist, as the E4X delete command doesn't throw an exception if the element is missing.
// Remember to save a copy of the document after running the script!

// abracadabraTools is a set of free utilities created by abracadabraPDF.net
// abracadabraTools adds many useful functions into Adobe Acrobat
// abracadabraTools runs with Mac OS and Windows
// Copyrights - JR Boulay - 2002-2026 - https://www.abracadabrapdf.net/contact/
// Support & assistance : https://www.abracadabrapdf.net/forums/index.php/board,15.0.html

////////////////////////---FRANAIS---////////////////////////

// abracadabraTools-Remove-xmpMM supprime les balises XMPmm
// abracadabraTools-Remove-xmpMM est disponible dans le menu Edition ou dans le menu Hamburger, et comme icne dans les Outils complmentaires
// abracadabraTools-Remove-xmpMM requiert Acrobat Pro ou Acrobat Standard

// Les balises xmpMM contiennent souvent des informations prives sur l'historique du document, qu'on ne souhaite pas forcment rendre publiques.
// Ce script supprime les balises xmpMM des mtadonnes du document, ainsi que, le cas chant, la balise prive cre par Adobe InDesign.
// Il n'est pas ncessaire de vrifier si les balises existent car la commande de suppression E4X ne gnre pas d'exception si l'lment est manquant.
// N'oubliez pas d'enregistrer une copie du document aprs avoir excut le script !

// abracadabraTools est un ensemble d'utilitaires gratuits offert par abracadabraPDF.net
// abracadabraTools ajoute des fonctions utiles dans le logiciel Adobe Acrobat
// abracadabraTools fonctionne sur systmes Mac OS et Windows
// Tous droits rservs - JR Boulay - 2002-2026 - https://www.abracadabrapdf.net/contact/
// Support & assistance : https://www.abracadabrapdf.net/forums/index.php/board,15.0.html


////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

if (typeof app.formsVersion != "undefined" && app.formsVersion > 9 && app.viewerType != "Reader") {


	if (global.aTalert != 1) {
		var strTitreId = "ABRACADABRATOOLS";
		if (app.platform == "MAC") {var aTprefx = "ABRACADABRATOOLS\n";}
		else {var aTprefx = "";}
		global.aTalert = 1;
	}

	// LANGAGE
	if (app.language == "FRA") {
		var xmIt01 = aTprefx + "SUPPRIMER BALISES XMPMM\n\n\nOp\u00E9ration termin\u00E9e.";
		var xmIt02 = aTprefx + "SUPPRIMER BALISES XMPMM\n\n\nOp\u00E9ration interdite : les param\u00E8tres de protection de ce document interdisent toute modification.";
		var xmIt03 = "Supprimer balises XMP";
		var xmIt04 = "Supprimer balises xmpMM";
		var xmIt05 = aTprefx + "SUPPRIMER BALISES XMPMM\n\n\nLes donn\u00E9es xmpMM contiennent souvent des informations priv\u00E9es sur l'historique du document, qu'on ne souhaite pas forc\u00E9ment rendre publiques.\n\nVoulez-vous vraiment supprimer les balises xmpMM de ce document ?\nCette action ne pourra pas \u00EAtre annul\u00E9e.";
	}
	else {
		var xmIt01 = aTprefx + "REMOVE XMPMM DATA\n\n\nDone.";
		var xmIt02 = aTprefx + "REMOVE XMPMM DATA\n\n\nNot Allowed: security settings on this file prevent changes";
		var xmIt03 = "Remove XMP data";
		var xmIt04 = "Remove xmpMM data";
		var xmIt05 = aTprefx + "REMOVE XMPMM DATA\n\n\nThe xmpMM tags often contain private information about the history of the document, which should not be made public.\n\nDo you really want to delete the xmpMM data in this document?\nThis action cannot be undone.";
	}
 
////////////////////////////////////////////////////////////////////////////////////////////////////
// MINIFICATION


	function supXMPmm(tDoc) {

		var xml = new XML(tDoc.metadata);
		var nsrdf = new Namespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
		var nsidp = new Namespace("http://ns.adobe.com/xmp/InDesign/private");
		var nsmm = new Namespace("http://ns.adobe.com/xap/1.0/mm/");
		delete xml.nsrdf::RDF.nsrdf::Description.nsmm::History;
		delete xml.nsrdf::RDF.nsrdf::Description.nsmm::Manifest;
		delete xml.nsrdf::RDF.nsrdf::Description.nsmm::DerivedFrom;
		delete xml.nsrdf::RDF.nsrdf::Description.@nsmm::DocumentID;
		delete xml.nsrdf::RDF.nsrdf::Description.@nsmm::OriginalDocumentID;
		delete xml.nsrdf::RDF.nsrdf::Description.@nsmm::RenditionClass;
		delete xml.nsrdf::RDF.nsrdf::Description.@nsmm::InstanceID;
		delete xml.nsrdf::RDF.nsrdf::Description.@nsidp::DocChangeCount;

		try{tDoc.metadata=xml.toXMLString(),app.alert({cMsg:xmIt01,nIcon:3,nType:0,oDoc:tDoc,cTitle:strTitreId})}catch(t){app.alert({cMsg:xmIt02,nIcon:0,nType:0,cTitle:strTitreId})}
	}


function supXMPdata(){var f;"undefined"==typeof bClearDialogXMP&&(bClearDialogXMP=!0),bClearDialogXMP?(f={bInitialValue:!0,bAfterValue:!1},4==app.alert({cMsg:xmIt05,cTitle:strTitreId,oCheckbox:f,nIcon:2,nType:2})&&(bClearDialogXMP=!f.bAfterValue,supXMPmm(event.target))):supXMPmm(event.target)}var strNomMenu,papaMenu;1!=global.aTmenu&&(strNomMenu="abracadabraTools *",papaMenu=/AV2::HamburgerMenu/.test(app.listMenuItems())?"AV2::HamburgerMenu":"Edit",app.addSubMenu({cName:strNomMenu,cParent:papaMenu,nPos:0}),app.addMenuItem({cName:"-",cParent:papaMenu,nPos:0,cEnable:!1,cExec:null}),global.aTmenu=1),app.addMenuItem({cName:xmIt03,cParent:strNomMenu,nPos:0,cExec:"supXMPdata();",cEnable:"event.rc = (event.target != null);"});var strIconRSxmp="ffffffffff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ff8b0000ffffffffff8b0000ff8b0000ffffffffff8b0000ffffffffffffffffff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffffffffffff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffffffffffff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffffffffffff8b0000ffffffffffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffffffffffff8b0000ffffffffffffffffff8b0000ffffffffffffffffffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffffffffffff8b0000ffffffffffffffffff8b0000ffffffffffffffffffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffffffffffff8b0000ffffffffffffffffff8b0000ffffffffffffffffffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffff8b0000ffffffffff8b0000ffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ffffffffff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ff8b0000ffffffff",oIconRSxmp={count:0,width:20,height:20,read:function(f){return strIconRSxmp.slice(this.count,this.count+=f)}};app.addToolButton({cName:"RSxmpBt",cLabel:xmIt03,oIcon:oIconRSxmp,cTooltext:xmIt04,cExec:"supXMPdata()",cEnable:"event.rc = (event.target != null);"});
}

